/* SYSINFO      General system information
 *
 * This daemon detects several components of the computer, such as processor
 * and video adapter.
 *
 * (c) Copyright 1995 ITB CompuPhase, Netherlands
 */
#ifndef _SYSINFO_H
#define _SYSINFO_H

/* Daemons and applications using a daemon share the same structure. Alignment
 * (or "packing") of fields in a structure must be equivalent. Especially
 * since the daemon may be made with a different compiler than the application.
 */
#if defined(_MSC_VER)
#  pragma pack(1)       /* directive for Microsoft compilers */
#elif defined(__TURBOC__)
#  pragma -a-           /* directive for Borland compilers */
#endif

enum SYS_REQUESTS {
  SI_CPU,               /* processor: see CPU_TYPE enum */
  SI_FPU,               /* floating point unit available or absent */
  SI_CPUMODE,           /* processor mode: real, protected or V86 */
  SI_BUS,               /* bus type: see BUS_TYPE enum */
  SI_KBD,               /* keyboard type: XT or AT */
  SI_MEM,               /* base and extended memory */
  SI_XMS,               /* XMS version and free XMS memory */
  SI_EMS,               /* EMS version and free EMS memory */
  SI_VIDEO_HW,          /* video adapter: see VIDEO_HARDWARE enum */
  SI_VIDEO_SW,          /* video software support: see VIDEO_SOFTWARE enum */
  SI_VIDEO_MODES,       /* supported video modes: see VIDEO_MODE struct */
  SI_DRIVES,            /* disk drives: see DRIVE_INFO struct & DRIVE_TYPE enum */
  SI_RS232,             /* serial ports: see RS232_TYPE enum */
  SI_LPT,               /* parallel ports: see LPT_TYPE enum */
  SI_MOUSE,             /* mouse type and driver software */
  SI_PCMCIA,            /* PCMCIA support and version */
  SI_FULLPATH,          /* get full path of file or disk drive */
  SI_LPT_NAME,          /* get queue name of captured parallel port */
  SI_DISKETTE,          /* diskette drive type: see DISKETTEDRIVE_TYPE */
};

typedef struct {
  short mode;           /* mode number */
  short graphic;        /* 1 if this is a graphic mode, 0 if it is a text mode*/
  short resx, resy;     /* horizontal resolution in pixels of characters */
  short colour_bits;    /* 1=monochrome, 2=4 colours, 4=16 colurs, etc. */
} VIDEO_MODE;

#define DRIVE_NUM   26
typedef struct {
  char letter;          /* 'A' to 'Z' */
  short type;           /* one of the DRIVE_TYPE values defined below */
  unsigned char flags;  /* a combination of the DRV_xxx flags defined below */
} DRIVE_INFO;

enum DRIVE_TYPE {       /* type of drive */
  DRIVE_INVALID,        /* must be 0 */
  DRIVE_REMOVEABLE,
  DRIVE_FIXED,
  DRIVE_RAM,
  DRIVE_CDROM,
  DRIVE_NETWORK,
  DRIVE_SUBST,
};

#define DRV_CASE_SENSITIVE      0x01    /* case sensitive */
#define DRV_CASE_PRESERVED      0x02    /* case preserved (but case insensitive) */
#define DRV_UNICODE             0x04    /* Unicode (ASCII if not set) */
#define DRV_LFN_API             0x40    /* LFN functions are supported */
#define DRV_COMPRESSED          0x80    /* compressed disk */

enum DISKETTEDRIVE_TYPE {       /* type of diskette drive (not of diskette) */
  DDRIVE_NONE,          /* no drive */
  DDRIVE_360K,
  DDRIVE_1_2M,
  DDRIVE_720K,
  DDRIVE_1_44M,
  DDRIVE_2_88MP,        /* on some AMI BIOSes and presumably some IBM PS/2s */
  DDRIVE_2_88M,
  DDRIVE_320K,          /* obsolete */
  DDRIVE_UNKNOWN,       /* future type? */
};

enum CPU_TYPE {
  CPU_8086,     /* also for 8088 and NEC V20/V30 */
  CPU_80186,    /* also for 80188 */
  CPU_80286,
  CPU_80386,    /* includes 386SX, 386SLC and others */
  CPU_80486,    /* includes 486SX, 486SLC and others */
  CPU_PENTIUM,
};

enum FPU_TYPE {
  FPU_NONE,     /* no floating point unit present */
  FPU_8087,     /* 8087 */
  FPU_80287,    /* 80287 */
  FPU_80387,    /* 80387 */
  FPU_80487,    /* 80486DX with FPU or 80486SX with a 80487 */
  FPU_80587,    /* Pentium (or equivalent) with an FPU */
  FPU_587BUG,   /* Pentium FPU with infamous FDIV bug */
  FPU_WEITEK = 0x100,   /* Weitek Abacus 3167 or 4167 */
};

enum BUS_TYPE {
  BUS_PC,       /* old 8-bit bus in PC or PC-XT */
  BUS_PCJR,     /* PC junior */
  BUS_UNKNOWN,  /* other system based on a bus for 8088 or 8086 */
  BUS_XT286,    /* 80286 based XT (short-lived) */
  BUS_ISA,      /* 16-bit ISA bus or AT-bus */
  BUS_EISA,
  BUS_MCA,
  BUS_PCI,
};

enum CPU_MODE {
  MODE_REALONLY,/* this processor can only run in real mode */
  MODE_REAL,
  MODE_PROT,    /* should never be returned, not supported */
  MODE_V86,
};

enum VIDEO_HARDWARE {
  VH_UNKNOWN,
  VH_NONE,      /* no display or graphics adapter present */
  VH_MDA,
  VH_CGA,
  VH_EGA,
  VH_EGA_CGD,   /* EGA with CGA display */
  VH_EGA_MONO,  /* EGA with MDA display */
  VH_MCGA,
  VH_MCGA_MONO, /* MCGA with monochrome analogue monitor */
  VH_VGA,
  VH_VGA_MONO,
  VH_HERCULES,
  VH_SVGA,      /* generic SuperVGA (with VESA support) */
  VH_SVGA_MONO,
  VH_8514,      /* IBM 8514/A */
  VH_XGA,       /* IBM XGA */
  VH_XGA_MONO,
};

enum VIDEO_SOFTWARE {
  VS_UNKNOWN,
  VS_AI,        /* IBM AI, for 8514/A and XGA */
  VS_DMQS,      /* IBM Display Mode Query and Set */
  VS_VESA,      /* VESA Video BIOS Extensions */
};

typedef struct {
  short type;
  short port;
} PORT_INFO;

#define RS232_NUM   4
enum RS232_TYPE {
  RS_NONE,      /* no serial port found at this address */
  RS_8250,      /* 8250, 8250-B or 8250C; 56000 baud max. */
  RS_16450,     /* 16450 or 8250A; 115200 baud max. */
  RS_16C1450,   /* 16450 + software controlled power down & reset */
  RS_16550A,    /* bad FIFO type */
  RS_16550AF,   /* 16550AF, 16550C or 16550CF (good FIFO types) */
  RS_16C1550,   /* 16550 + software controlled power down & reset */
  RS_16552,     /* dual UART */
  RS_82510,     /* Intel instead of National Semiconductor */
};

#define LPT_NUM 3       /* most systems cannot support > 3 printer ports */
enum LPT_TYPE {
  LPT_NONE,     /* not a valid port (no hardware, port not captured) */
  LPT_NORMAL,
  LPT_BIDIR,    /* bidirectional printer port */
  LPT_ECP,      /* enhanced parallel port (HP/Micrsoft) */
  LPT_EPP,      /* enhanced parallel port (Intel), also called FPP */
  LPT_NET,      /* captured network port */
};

enum MOUSE_TYPE {
  MOUSE_NONE,   /* no mouse detected */
  MOUSE_BUS,    /* Bus mouse */
  MOUSE_MSSER,  /* Microsoft compatible serial mouse */
  MOUSE_INPORT, /* InPort mouse */
  MOUSE_PS2,    /* IBM PS/2 style mouse */
  MOUSE_HP,     /* HP mouse */
  MOUSE_UNKNOWN,/* mouse installed, but type is unknown */
};


/* function prototypes */
short D_EXPORT si_diskette(char drive);
short D_EXPORT si_drives(DRIVE_INFO _far *drivelist, short maxdrives);
short D_EXPORT si_ems(unsigned short _far *version, unsigned short _far *free);
short D_EXPORT si_keyboard(void);
short D_EXPORT si_lpt(PORT_INFO _far *lpt_list, short maxports);
char _far * D_EXPORT si_lptname(char _far *name, short port);
void  D_EXPORT si_memory(unsigned short _far *dos, unsigned short _far *base,
                         unsigned short _far *extended);
short D_EXPORT si_modelist(VIDEO_MODE _far *modes, short maxmodes);
void  D_EXPORT si_mouse(short _far *type, short _far *software,
                        short _far *port);
short D_EXPORT si_pcmcia(unsigned short _far *version, short _far *sockets);
short D_EXPORT si_rs232(PORT_INFO _far *rs232list, short maxports);
void  D_EXPORT si_system(short _far *fcpu, short _far *ffpu, short _far *bus,
                         short _far *mode);
char _far * D_EXPORT si_fullpath(char _far *target, char _far *source,
                                 short method);
void  D_EXPORT si_video(short _far *type, unsigned short _far *memory,
                        short _far *chipset, short _far *software,
                        unsigned short _far *version);
short D_EXPORT si_xms(unsigned short _far *version, unsigned short _far *free);

#endif
