/* TABULA       Reading and writing comma separated files
 *
 * (c) Copyright 1995 ITB CompuPhase, Netherlands
 */
#ifndef _TABULA_H
#define _TABULA_H

enum {
  FLD_EMPTY,
  FLD_UNKNOWN,
  FLD_LONG,
  FLD_STRING,
  FLD_ENDREC,   // end of record
};

enum {
  TAB_NOERROR = 0,
  TAB_NOFILE = 2,
  TAB_NOPATH,
  TAB_NOHANDLES,
  TAB_NOACCESS,
  TAB_INVHANDLE,
  TAB_WRPROTECT = 19,
  TAB_NORECORD = 256,
  TAB_INVALID,    // record is not "valid", i.e. no record was read
  TAB_DISKFULL,
  TAB_TRUNCATED,  // field was not inserted completely, record buffer too small
};

#define MAX_RECORDS     0x7fffffffL

typedef struct {
  int handle;
  unsigned char _far *record;   // pointer to record buffer (from application)
  unsigned short length;        // length of the record buffer
  unsigned char specialchar[6];
  long rrpos;                   // file offset for reading
  unsigned char _far *rfpos;    // pointer to current field (in the record) for reading
  long wrpos;
  unsigned char _far *wfpos;
  long number;                  // current record number
  int valid;                    // is the buffer loaded?
} REC;


int   D_EXPORT tab_close(REC _far *rec);
short D_EXPORT tab_count(REC _far *rec);
int   D_EXPORT tab_delete(REC _far *rec);
int   D_EXPORT tab_find(REC _far *rec, short fieldnr, short type,
                        char _far *value, char _far *buffer, short maxlen);
long  D_EXPORT tab_getl(REC _far *rec);
char _far * D_EXPORT tab_getrec(REC _far *rec);
char _far * D_EXPORT tab_gets(REC _far *rec, char _far *string, short maxlen);
void  D_EXPORT tab_new(REC _far *rec, short fields);
int   D_EXPORT tab_open(REC _far *rec, char _far *filename, int writeaccess,
                        char _far *buffer, unsigned short length);
int   D_EXPORT tab_read(REC _far *rec);
void  D_EXPORT tab_reset(REC _far *rec);
void  D_EXPORT tab_setchar(REC _far *rec, char recsep, char fldsep, char string,
                           char escape, char space);
int   D_EXPORT tab_setl(REC _far *rec, long value);
long  D_EXPORT tab_setpos(REC _far *rec, long number);
int   D_EXPORT tab_setraw(REC _far *rec, char _far *string);
int   D_EXPORT tab_sets(REC _far *rec, char _far *string);
void  D_EXPORT tab_skip(REC _far *rec, short number);
short D_EXPORT tab_type(REC _far *rec);
int   D_EXPORT tab_write(REC _far *rec);

#endif  // _TABULA_H
